package gov.va.vinci.dart.json.builder;

import gov.va.vinci.dart.biz.Person;
import gov.va.vinci.dart.json.PersonListView;
import gov.va.vinci.dart.json.PersonView;
import gov.va.vinci.dart.json.atom.AtomLinkFactory;
import gov.va.vinci.dart.json.atom.LinkListView;
import gov.va.vinci.dart.json.atom.LinkView;
import gov.va.vinci.dart.json.atom.Relation;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PersonListViewBuilder {
	@Autowired 
	private AtomLinkFactory linkFactory;
	
	public PersonListView build(final List<Person> personList) {
		PersonListView result = new PersonListView();
		for (Person pers : personList) {
			PersonView view = new PersonView();
			view.setId(pers.getId());
			view.setName(pers.getName());
			view.setDescription(pers.getDescription());
			view.setFullName(pers.getFullName());
			view.setLocationId(pers.getLocation().getId());
			
			LinkListView linkListView = new LinkListView();
			view.setLinks(linkListView);
			
			LinkView link = linkFactory.buildLink("/persons/" + pers.getId(), Relation.SELF);
			linkListView.getLink().add(link);
			link = linkFactory.buildLink("/persons/" + pers.getId() + "/tasks", Relation.RELATED);
			linkListView.getLink().add(link);
			link = linkFactory.buildLink("/persons/" + pers.getId() + "/roles", Relation.RELATED);
			linkListView.getLink().add(link);
			link = linkFactory.buildLink("/persons/" + pers.getId() + "/groups", Relation.RELATED);
			linkListView.getLink().add(link);

			result.getPersons().add(view);
		}
		
		return result;
	}
}
